#!/usr/bin/env bash
set -euo pipefail

export DEBIAN_FRONTEND=noninteractive

# -------- helpers --------
retry() {
  local cmd="$1"
  local what="$2"
  until eval "$cmd"; do
    echo "$what failed, retrying in 5 seconds…"
    sleep 5
  done
}

# -------- remove any old Docker bits --------
retry "apt-get remove -y docker.io docker-doc docker-compose containerd runc || true" "apt-get remove"

# -------- base package refresh --------
retry "apt-get update -y"                                      "apt-get update"
retry "apt-get install -y apt-transport-https ca-certificates curl software-properties-common" \
      "install prerequisites"

# -------- add Docker repo & key --------
if [[ ! -f /usr/share/keyrings/docker-archive-keyring.gpg ]]; then
  curl -fsSL https://download.docker.com/linux/ubuntu/gpg \
    | gpg --dearmor -o /usr/share/keyrings/docker-archive-keyring.gpg
fi

lsb_release -cs | read -r codename
echo \
  "deb [arch=amd64 signed-by=/usr/share/keyrings/docker-archive-keyring.gpg] \
  https://download.docker.com/linux/ubuntu ${codename} stable" \
  > /etc/apt/sources.list.d/docker.list

retry "apt-get update -y"                                      "apt-get update (Docker repo)"

# -------- install Docker engine & plugins --------
retry "apt-get install -y docker-ce docker-ce-cli containerd.io docker-buildx-plugin docker-compose-plugin" \
      "install Docker"

# -------- enable & start --------
systemctl enable --now docker

# -------- quick validation --------
docker run --rm hello-world
echo "✅ Docker installed and working."
